#include <iostream>
#include <vector>
#include <utility>

int main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(nullptr);

    int q;
    std::cin >> q;
    std::vector<int> results(q);
    std::vector<std::pair<bool, bool>> sequence(200000);

    for (int t = 0; t < q; ++t) {
        int n, matches = 0;
        std::cin >> n;

        for (int i = 0; i < n; ++i) {
            int x;
            std::cin >> x;
            sequence[i].first = x & 1;
        }

        for (int i = 0; i < n; ++i) {
            int x;
            std::cin >> x;
            sequence[i].second = x & 1;
        }

        if (sequence[0].second != sequence[1].first) {
            std::swap(sequence[0].first, sequence[0].second);
        }

        for (int i = 1; i < n - 1; ++i) {
            if (sequence[i].first != sequence[i].second && sequence[i-1].second != sequence[i].first) {
                std::swap(sequence[i].first, sequence[i].second);
            }
        }

        if (sequence[n-2].second != sequence[n-1].first) {
            std::swap(sequence[n-1].first, sequence[n-1].second);
        }

        for (int i = 0; i < n - 1; ++i) {
            matches += (sequence[i].first == sequence[i].second) + (sequence[i].second == sequence[i+1].first);
        }
        matches += (sequence[n-1].first == sequence[n-1].second);

        results[t] = matches;
    }

    for (int result : results) {
        std::cout << result << '\n';
    }

    return 0;
}